﻿using System;

namespace KeyConfig
{
	/// <summary>
	/// 特定の型のイベントデータを格納するクラスです。
	/// </summary>
	public class DataEventArgs<T> : EventArgs
	{
		/// <summary>
		/// DataEventArgsのインスタンスを作成します。
		/// </summary>
		public DataEventArgs(T value)
		{
			this.Value = value;
		}

		/// <summary>
		/// イベントのデータです。
		/// </summary>
		public T Value { get; private set; }
	}
}